from sklearn.ensemble import AdaBoostClassifier
from sklearn.naive_bayes import BernoulliNB
from sklearn.naive_bayes import ComplementNB
from sklearn.tree import DecisionTreeClassifier
from sklearn.ensemble import ExtraTreesClassifier
from sklearn.ensemble import GradientBoostingClassifier
from sklearn.neighbors import KNeighborsClassifier
from sklearn.linear_model import LogisticRegression
from sklearn.neural_network import MLPClassifier
from sklearn.naive_bayes import GaussianNB
from sklearn.linear_model import PassiveAggressiveClassifier
from sklearn.linear_model import Perceptron
from sklearn.neighbors import RadiusNeighborsClassifier
from sklearn.ensemble import RandomForestClassifier
from sklearn.linear_model import RidgeClassifier
from sklearn.linear_model import SGDClassifier
from sklearn.svm import SVC
from xgboost import XGBClassifier
from xgboost import  XGBRFClassifier
import pandas as pd
import numpy as np
from sklearn.metrics import *
from pathlib import Path

def evaluate_model(trainX, trainy, testX, testy, model, name,dataset):
    # fit the model
    model.fit(trainX, trainy)
    # make predictions
    yhat = model.predict(testX)
    yhat = np.array(yhat).reshape(len(yhat), 1)

    testy = np.array(testy).reshape(len(testy), 1)

    # evaluate predictions
    accuracy = accuracy_score(testy, yhat)
    accuracy = accuracy * 100.0

    kappa = cohen_kappa_score(testy, yhat)
    kappa = kappa * 100.0
    f1Score = f1_score(testy, yhat, average='weighted')
    recall_s = recall_score(testy, yhat, average='weighted')
    precision_s = precision_score(testy, yhat, average='weighted')
    raucScore = roc_auc_score(testy, yhat)
    matthewsCoff= matthews_corrcoef(testy, yhat)

    Path("results/%s" % dataset).mkdir(parents=True, exist_ok=True)
    Path("results/%s/%s" % (dataset, name)).mkdir(parents=True, exist_ok=True)
    file_name = r'results/%s/%s/Accuracy.txt' %(dataset, name)
    myfile=Path(file_name)
    if myfile.exists():
        True
    else:
        with open(file_name, 'a+') as x_file1:
            x_file1.write('Algorithm \t & Accuracy \t &Kappa \t & F1 \t & Recall \t & Precision \t & Roc measure \t & MatthewsCoff \n')
            x_file1.close()

    with open(file_name, 'a+') as x_file:
        x_file.write('%s.\t' % name)
        x_file.write('& %.4f\t' % accuracy)
        x_file.write('& %.4f \t' % kappa)
        x_file.write('& %.4f\t' % f1Score)
        x_file.write('& %.4f\t' % recall_s)
        x_file.write('& %.4f\t' % precision_s)
        x_file.write('& %.4f\t' % raucScore)
        x_file.write('& %.4f \n' % matthewsCoff)
        x_file.close()

    return accuracy, kappa

